# Temp Mail Control (Working Script + Admin Panel)

This project is now a full Node.js application with:

- Public temp-mail page
- Backend API proxy to GuerrillaMail
- Admin authentication
- Admin dashboard (stats, sessions, logs, settings, password change)
- Domain manager in admin panel (add/delete domains)
- SQLite database for control and tracking

## Requirements

- Node.js 18+ (recommended 20+)
- npm

## Setup

1. Install dependencies:

```bash
npm install
```

2. Create `.env` from `.env.example`:

```bash
copy .env.example .env
```

3. Edit `.env` values (especially `JWT_SECRET` and admin password).

## Run

```bash
npm start
```

Server runs at:

- Public site: `http://localhost:3000/`
- Admin panel: `http://localhost:3000/admin`

## Default Admin

If no admin exists, app creates one using `.env`:

- `ADMIN_USERNAME`
- `ADMIN_PASSWORD`

Change password after first login from admin panel.

## Admin Controls

- View live usage stats
- Enable/disable mailbox sessions
- View action logs
- Add or delete domains from Domain Manager
- Update site settings:
  - `site_name`
  - `notice`
  - `messages_limit`
- Change admin password

## Project Structure

```
server.js
src/
  db.js
  middleware/auth.js
  routes/public.js
  routes/admin.js
  services/guerrilla.js
public/
  index.html
  app.js
  styles.css
  admin/
    index.html
    app.js
    styles.css
```

## Notes

- Temporary mailbox engine uses GuerrillaMail API.
- No default domains are preloaded now.
- Public mailbox creation works only after you add at least one domain from admin panel.
- This app stores only control metadata (sessions/events/settings), not full mail content.
- Database file is created at `data/app.db`.
